/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsenchantments.enchantments;

import com.majruszsenchantments.Registries;
import com.mlib.EquipmentSlots;
import com.mlib.Random;
import com.mlib.config.ConfigGroup;
import com.mlib.config.DoubleArrayConfig;
import com.mlib.config.DoubleConfig;
import com.mlib.config.IConfigurable;
import com.mlib.contexts.OnEnchantmentAvailabilityCheck;
import com.mlib.contexts.OnEquipmentChanged;
import com.mlib.contexts.OnExtraFishingLootCheck;
import com.mlib.contexts.OnItemFished;
import com.mlib.contexts.OnPreDamaged;
import com.mlib.contexts.base.Condition;
import com.mlib.contexts.base.ModConfigs;
import com.mlib.contexts.base.Priority;
import com.mlib.enchantments.CustomEnchantment;
import com.mlib.items.ItemHelper;
import com.mlib.math.Range;
import com.mlib.modhelper.AutoInstance;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;

public class FishingFanaticEnchantment
extends CustomEnchantment {
    public FishingFanaticEnchantment() {
        this.rarity(Enchantment.Rarity.UNCOMMON).category(EnchantmentCategory.FISHING_ROD).slots(EquipmentSlots.BOTH_HANDS).maxLevel(8).minLevelCost(level -> level * 10).maxLevelCost(level -> level * 10 + 20);
    }

    public Component m_44700_(int level) {
        if (level == this.m_6586_()) {
            return Component.m_237115_((String)"enchantment.majruszsenchantments.fishing_fanatic.true").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.BOLD});
        }
        return super.m_44700_(level);
    }

    public boolean m_6594_() {
        return false;
    }

    public boolean m_6081_(ItemStack itemStack) {
        return this.f_44672_.m_7454_(itemStack.m_41720_());
    }

    public boolean canApplyAtEnchantingTable(ItemStack itemStack) {
        return false;
    }

    public boolean m_6591_() {
        return true;
    }

    @AutoInstance
    public static class Handler {
        static final ResourceLocation SPECIAL_LOOT_TABLE = Registries.getLocation("gameplay/fishing/fishing_fanatic_extra");
        static final Function<Integer, String> LEVEL_FORMAT = idx -> String.format("level_%d", idx + 1);
        final DoubleArrayConfig levelUpChances = new DoubleArrayConfig(LEVEL_FORMAT, Range.CHANCE, new double[]{0.06, 0.05, 0.04, 0.03, 0.02, 0.01, 0.004, 0.002});
        final DoubleArrayConfig specialDropChance = new DoubleArrayConfig(LEVEL_FORMAT, Range.CHANCE, new double[]{0.0, 0.0, 0.0, 0.0025, 0.0075, 0.02, 0.04, 0.06});
        final DoubleConfig extraLootChance = new DoubleConfig(0.33333, Range.CHANCE);
        final DoubleConfig rainMultiplier = new DoubleConfig(2.0, new Range((Number)1.0, (Number)10.0));
        final DoubleConfig damageBonus = new DoubleConfig(1.0, new Range((Number)0.0, (Number)5.0));
        final Supplier<FishingFanaticEnchantment> enchantment = Registries.FISHING_FANATIC;

        public Handler() {
            ConfigGroup group = ModConfigs.registerSubgroup((String)Registries.Groups.ENCHANTMENT).name("FishingFanatic").comment("Gives a chance to catch additional items from fishing.");
            OnEnchantmentAvailabilityCheck.listen((Consumer)OnEnchantmentAvailabilityCheck.ENABLE).addCondition(OnEnchantmentAvailabilityCheck.is(this.enchantment)).addCondition(OnEnchantmentAvailabilityCheck.excludable()).insertTo(group);
            OnExtraFishingLootCheck.listen(this::increaseLoot).name("Loot").addCondition(Condition.hasEnchantment(this.enchantment, data -> data.player)).addCondition(Condition.predicate(data -> OnEnchantmentAvailabilityCheck.dispatch((CustomEnchantment)this.enchantment.get()).isEnabled())).addConfig((IConfigurable)this.specialDropChance.name("SpecialDropChances").comment("Chance for each extra item to be replaced with a better one.")).addConfig((IConfigurable)this.extraLootChance.name("extra_loot_chance").comment("Independent chance for extra loot per enchantment level.")).insertTo(group);
            OnItemFished.listen(this::tryToLevelUp).priority(Priority.LOWEST).name("LevelUp").addCondition(Condition.predicate(data -> OnEnchantmentAvailabilityCheck.dispatch((CustomEnchantment)this.enchantment.get()).isEnabled())).addConfig((IConfigurable)this.levelUpChances.name("Chances").comment("Chances to acquire given enchantment level when an item is fished out.")).addConfig((IConfigurable)this.rainMultiplier.name("rain_multiplier").comment("Chance multiplier when it rains.")).insertTo(group);
            OnEquipmentChanged.listen(Handler::giveExtremeAdvancement).addCondition(Handler.hasBestFishingEnchantments()).addCondition(Condition.predicate(data -> data.entity instanceof ServerPlayer)).insertTo(group);
            OnPreDamaged.listen(this::increaseDamageDealt).addCondition(Condition.hasEnchantment(this.enchantment, data -> data.attacker)).addConfig((IConfigurable)this.damageBonus.name("damage_bonus").comment("Amount of extra damage dealt by the fishing rod per enchantment level.")).insertTo(group);
        }

        private void increaseLoot(OnExtraFishingLootCheck.Data data) {
            ItemStack fishingRod = data.fishingRod;
            int fanaticLevel = this.enchantment.get().getEnchantmentLevel(fishingRod);
            List<ItemStack> extraLoot = this.spawnExtraLoot(data, fanaticLevel);
            data.extraExperience += extraLoot.size() + Random.nextInt((int)1, (int)(2 * extraLoot.size() + 1));
            data.extraLoot.addAll(extraLoot);
        }

        private List<ItemStack> spawnExtraLoot(OnExtraFishingLootCheck.Data data, int fanaticLevel) {
            LootContext lootContext = data.generateLootContext();
            LootTable standardLootTable = Handler.getLootTable(BuiltInLootTables.f_78720_);
            LootTable specialLootTable = Handler.getLootTable(SPECIAL_LOOT_TABLE);
            ArrayList<ItemStack> extraLoot = new ArrayList<ItemStack>();
            for (int i = 0; i < fanaticLevel; ++i) {
                if (!Random.tryChance((double)((Double)this.extraLootChance.get()))) continue;
                LootTable lootTable = Random.tryChance((double)this.specialDropChance.get(fanaticLevel - 1)) ? specialLootTable : standardLootTable;
                extraLoot.addAll((Collection<ItemStack>)lootTable.m_230922_(lootContext));
            }
            return extraLoot;
        }

        private void tryToLevelUp(OnItemFished.Data data) {
            boolean isRaining = data.getLevel().m_46471_();
            double rainMultiplier = isRaining ? (Double)this.rainMultiplier.get() : 1.0;
            ItemStack fishingRod = ItemHelper.getMatchingHandItem((LivingEntity)data.player, itemStack -> itemStack.m_41720_() instanceof FishingRodItem);
            int fanaticLevel = this.enchantment.get().getEnchantmentLevel(fishingRod);
            if (fanaticLevel == this.enchantment.get().m_6586_() || !Random.tryChance((double)(this.levelUpChances.get(fanaticLevel) * rainMultiplier))) {
                return;
            }
            this.enchantment.get().increaseEnchantmentLevel(fishingRod);
            Player player = data.player;
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                Handler.giveAdvancement(player2, "fishing_fanatic", () -> fanaticLevel + 1 == 1);
                Handler.giveAdvancement(player2, "fishing_fanatic_true", () -> fanaticLevel + 1 == this.enchantment.get().m_6586_());
                Handler.giveAdvancement(player2, "nothing_can_stop_me", () -> isRaining);
            }
            Handler.sendLevelUpMessage(data.player);
        }

        private void increaseDamageDealt(OnPreDamaged.Data data) {
            data.extraDamage = (float)((double)data.extraDamage + (Double)this.damageBonus.get() * (double)this.enchantment.get().getEnchantmentLevel(data.attacker));
            data.spawnMagicParticles = true;
        }

        private static void giveAdvancement(ServerPlayer player, String type, Supplier<Boolean> check) {
            if (check.get().booleanValue()) {
                Registries.HELPER.triggerAchievement(player, type);
            }
        }

        private static void giveExtremeAdvancement(OnEquipmentChanged.Data data) {
            Handler.giveAdvancement((ServerPlayer)data.entity, "fishing_fanatic_extreme", () -> true);
        }

        private static LootTable getLootTable(ResourceLocation location) {
            return ServerLifecycleHooks.getCurrentServer().m_129898_().m_79217_(location);
        }

        private static void sendLevelUpMessage(Player player) {
            String keyId = "enchantment.majruszsenchantments.fishing_fanatic.level_up";
            player.m_5661_((Component)Component.m_237115_((String)keyId).m_130940_(ChatFormatting.BOLD), true);
        }

        private static Condition<OnEquipmentChanged.Data> hasBestFishingEnchantments() {
            return new Condition(data -> ForgeRegistries.ENCHANTMENTS.getValues().stream().allMatch(enchantment -> enchantment.m_6589_() || !enchantment.canApplyAtEnchantingTable(new ItemStack((ItemLike)Items.f_42523_)) || EnchantmentHelper.getTagEnchantmentLevel((Enchantment)enchantment, (ItemStack)data.event.getTo()) == enchantment.m_6586_()));
        }
    }
}

